/********************************************************************************
 		Remote Control State Machine
		Mauro Grassi May 2008 for Musicolour BETA ver 8.0 and above
 		based on code by Peter Smith
		Infrared receive state machine (must be called every 64us)
*********************************************************************************/
#include "p18f1320.h"
#include "ir.h"

byte Codes[IRKEYS];

rom  byte irCodes[IRKEYS]=
{  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x10, 0x11, 0x20, 0x21, 0x2D, 0x3C, 0x36, 0x0F, 0x35 , 0x37  };
// Some common codes for the VCR115 digitech remote
// numbers 0 to 9 = 0x00 to 0x09
// Volup=0x10 VolDown=0x11 OK=0x0B, MUTE=0x0D, PAUSE=0x29, STOP=0x36 REC=0x37 PLAY=0x35 ChannelUp=0x20 ChannelDown=0x21 MENU=0x1D OK=0x0x0B
// KEY		 0        1       2       3       4       5       6       7       8       9    DIMUP   DIMDOWN  MODE UP      MODE DOWN       TOGGLE 	 MENU    INFO    OK 	PLAY  RECORD
// Remote	 0        1       2       3       4       5       6       7       8       9    VolUp   VolDwn 	Channel Up	 Channel Down	 MUTE	   	 MENU    STOP    OK		PLAY  REC 

void readRemoteControlCodes(void)
{
	int i;
	for(i=0; i<IRKEYS; i++)
	{
	Codes[i]=ReadEEPROM(REMOTE_CONTROL_DEFS_ADDRESS+1+i);
	}
}

void writeRemoteControlCodes(void)
{
	int i;
	for(i=0; i<IRKEYS; i++)
	{
	WriteEEPROM(REMOTE_CONTROL_DEFS_ADDRESS+1+i, Codes[i]);
	}
}

byte keyCodeDefined(byte key, int i)
{
	// checks if the key has already been defined!
	int j;
	byte b;

	b=0;
	j=0;
	while((b==0)&&(j<i))
	{
	if(Codes[j]==key)b=1;
	j++;
	}
	return b;
}

void reDefineRemoteControlCodes(void)
{
	// here the user can define the remote control codes...
	int i;
	byte argtarg;
	byte myKey;
	
	blinkString(enterMenuString);
	DelayTenthMs(STARTUP_DELAY);
	argtarg=0;
	for(i=0; i<IRKEYS; i++)
	{
     initKeys();
     ackKey();
	 while(keyFull==0)
	 {
	  blinkKey(i+1, argtarg);
	  argtarg^=1;
	  DelayTenthMs(PROGRAM_DELAY);
	  }
	  myKey=ir_cmd;
	  if(keyCodeDefined(myKey, i))i--; else Codes[i]=myKey;				// do not allow duplicate definitions
	  DelayTenthMs(MAJOR_DELAY);
	 }
	 blinkString(exitMenuString);
	 writeRemoteControlCodes();
}

void defineDefaultRemoteControl(void)
{
	int i, j;
	//
	i=ReadEEPROM(REMOTE_CONTROL_DEFS_ADDRESS);
	//
	if(i!=MAGIC_REMOTE_CONTROL_VALUE)
	{
	for(i=0; i<IRKEYS; i++)
	{
	WriteEEPROM(REMOTE_CONTROL_DEFS_ADDRESS+1+i, irCodes[i]); 
	}
	WriteEEPROM(LAMPBRIGHTNESS_ADR, 0);
	WriteEEPROM(VERHIGH_ADR, VERHIGH);
	WriteEEPROM(VERLOW_ADR, VERLOW);
	WriteEEPROM(MODE_ADR,0);
	WriteEEPROM(SAVEMODE_ADR,0);
	WriteEEPROM(SAVEBRIGHTNESS_ADR,0);
	WriteEEPROM(FLASHMODULUS_ADR, FLASH_MODULUS);
	WriteEEPROM(TIMEOUTHI_ADR, 0);
	WriteEEPROM(TIMEOUTLO_ADR, DEFAULT_TIMEOUT_PERIOD);
	WriteEEPROM(QUIESCENT_ADR, 0);
	WriteEEPROM(ADDRESS_ADR, 0);
	WriteEEPROM(LIMITING0_ADR, DEFAULT_LIMITING0);
	WriteEEPROM(LIMITING1_ADR, DEFAULT_LIMITING1);
	WriteEEPROM(OFFSETLO_ADR,0);
	WriteEEPROM(OFFSETHI_ADR,0);
	WriteEEPROM(OFFSET1LO_ADR,0);
	WriteEEPROM(OFFSET1HI_ADR,0);
	WriteEEPROM(LOOPDELAY_ADR, DEFAULT_LOOPDELAY);
	WriteEEPROM(REMOTE_CONTROL_DEFS_ADDRESS, MAGIC_REMOTE_CONTROL_VALUE);
	}
	readRemoteControlCodes();
}

byte ir_timer;
byte ir_state, ir_bit_cnt;
int ir_cmd, ir_code;
byte ir_rpt;
byte ir_rdy;

void initRC5(void)
{
	ir_state=0;
	ir_timer=0;
	ir_rdy=0;
	ir_code=0;
	ir_cmd=0;
	ir_rpt=0;
	INTCON2bits.RBPU=1;	// disable pull ups
}

void ir_is_finished(void)
{
		ir_bit_cnt--;
		if(ir_bit_cnt!=0)
		{
			ir_state=5;
			ir_timer=0;
		} else 
		{
			if(ir_cmd==ir_code)ir_rpt++; else ir_rpt=0;
			ir_code=ir_cmd;
			ir_rdy|=1;
			ir_state=0;
		}	
}
/***************************************************************************
 RC5 State 6
 Bit was a low, so wait for rising edge to syncronize timing
***************************************************************************/
/*
void rc5_s6(void)
{
	if(IR_RXD==1)ir_is_finished();
	else if(ir_timer>THIRTY_FIVE)ir_state=0;
}
*/
/***************************************************************************
 RC5 State 7
 Bit was a high, so wait for falling edge to syncronize timing
**************************************************************************/
/*
void rc5_s7(void)
{
	if(IR_RXD==0)ir_is_finished();
	else if(ir_timer>THIRTY_FIVE)ir_state=0;
}
*/

int ir_receive(void)
{
	// this needs to be called approximately every 64us!
	ir_timer++;
	ir_state&=7;
	switch(ir_state)
	{
		default:
		case 0:
			//rc5_s0();
			if(IR_RXD==1){ ir_timer=0; ir_state++; }
			break;
		case 1:
			//rc5_s1();
			if(IR_RXD==0){ ir_state=0; } 
			else if(ir_timer>=SEVENTY_EIGHT)ir_state++;
			break;
		case 2:
			//rc5_s2();
			if(IR_RXD==0)
			{
			ir_timer=0;
			ir_state++;
			}
			break;
		case 3:
			//rc5_s3();
			if(IR_RXD==1){
			ir_timer=0;
			ir_state++;
			} else	if(ir_timer>=THIRTY_ONE)ir_state=0;		//  more than 2ms?
			break;
		case 4:
			//rc5_s4();
			if(IR_RXD==0){
				ir_bit_cnt=12;			// initialize bit count (12 bits)
				ir_cmd=0;				// zero the command
				ir_timer=0;				// reset timer
				ir_state++;
 				} else if(ir_timer>=THIRTY_ONE)ir_state=0;
			break;
		case 5:	
			//rc5_s5();
			if(ir_timer>=TWENTY_ONE)
			{
			ir_state++;
			ir_cmd=ir_cmd<<1;
			if(ir_bit_cnt<=6)
			{
			 if(IR_RXD==1)
			 {
			 ir_cmd|=1;
			 ir_state++;
			 } 
			} 		
			ir_timer=0;
			}
			break;
		case 6:
			//rc5_s6();
			if(IR_RXD==1)ir_is_finished();
			else if(ir_timer>THIRTY_FIVE)ir_state=0;
			break;
		case 7:
			//rc5_s7();
			if(IR_RXD==0)ir_is_finished();
			else if(ir_timer>THIRTY_FIVE)ir_state=0;
			break;
	}
	return 0;
}

byte translateIRCode(byte xx)
{
	byte i, k;
	byte j;
	k=0xFF;
	for(i=0; i<IRKEYS; i++)	
	{
	j=Codes[i];
	if(xx==j)k=i;
	}
    if(k!=0xFF)return (0x7F & (k+1)); else return (0x80 | xx);
}

